/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.project.options;

import com.aptana.editor.php.core.PHPNature;
import com.aptana.editor.php.epl.PHPEplPlugin;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org2.eclipse.php.internal.core.CoreMessages;
import org2.eclipse.php.internal.core.project.IIncludePathContainer;
import org2.eclipse.php.internal.core.project.IIncludePathEntry;
import org2.eclipse.php.internal.core.project.options.IPhpProjectOptionChangeListener;
import org2.eclipse.php.internal.core.project.options.XMLWriter;
import org2.eclipse.php.internal.core.project.options.includepath.IncludePathEntry;
import org2.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;

public class PHPProjectOptions {
    private static final String LOCATION_INCLUDE_PATH = "Include Path";
    private static final String OWNER_PHP_INCLUDE_PATH = "phpIncludePath";
    private static final String OWNER_ATTRIBUTE = "Owner";
    public static final String BUILDER_ID = "com.aptana.editor.php.aptanaPhpBuilder";
    static final IIncludePathEntry[] EMPTY_INCLUDEPATH = new IIncludePathEntry[0];
    private static final String PREF_QUALIFIER = "com.aptana.editor.php.epl.projectOptions";
    private static final String OLD_FILE_NAME = ".projectOptions";
    private static final String TAG_OPTION = "projectOption";
    private static final String TAG_OPTIONS = "phpProjectOptions";
    public static final String USER_LIBRARY_CONTAINER_ID = "org2.eclipse.php.USER_LIBRARY";
    private IIncludePathEntry[] includePathEntries = new IIncludePathEntry[0];
    private final Map<String, List<IPhpProjectOptionChangeListener>> optionsChangeListenersMap = new HashMap<String, List<IPhpProjectOptionChangeListener>>();
    private IProject project;
    private IEclipsePreferences preferences;

    public static PHPProjectOptions forProject(IProject project) {
        if (!project.exists() || !project.isAccessible()) {
            return null;
        }
        PHPNature nature = null;
        try {
            nature = (PHPNature)project.getNature("com.aptana.editor.php.phpNature");
        }
        catch (CoreException e) {
            PHPEplPlugin.logError("Unexpected exception", e);
        }
        return nature != null ? nature.getOptions() : null;
    }

    public static IIncludePathContainer getIncludePathContainer(IPath path, IProject project2) {
        return null;
    }

    public static IPath getIncludePathVariable(String variableName) {
        return IncludePathVariableManager.instance().getIncludePathVariable(variableName);
    }

    public static String[] getIncludePathVariableNames() {
        return IncludePathVariableManager.instance().getIncludePathVariableNames();
    }

    public static IPath getResolvedVariablePath(IPath path) {
        return IncludePathVariableManager.instance().getIncludePathVariable(path.toString());
    }

    public static void setIncludePathVariables(String[] names, IPath[] paths, SubProgressMonitor monitor) {
        IncludePathVariableManager.instance().setIncludePathVariables(names, paths, monitor);
    }

    public PHPProjectOptions(IProject project) {
        this.project = project;
        ProjectScope projectScope = new ProjectScope(project);
        this.preferences = projectScope.getNode(PREF_QUALIFIER);
        this.loadIncludePath();
        this.loadOldConfiguration();
    }

    public void addOptionChangeListener(String optionKey, IPhpProjectOptionChangeListener optionChangeListener) {
        List<IPhpProjectOptionChangeListener> optionChangeListeners = this.optionsChangeListenersMap.get(optionKey);
        if (optionChangeListeners == null) {
            optionChangeListeners = new ArrayList<IPhpProjectOptionChangeListener>();
            this.optionsChangeListenersMap.put(optionKey, optionChangeListeners);
        }
        if (!optionChangeListeners.contains(optionChangeListener)) {
            optionChangeListeners.add(optionChangeListener);
        }
    }

    public void removeOptionChangeListener(String optionKey, IPhpProjectOptionChangeListener optionChangeListener) {
        List<IPhpProjectOptionChangeListener> optionChangeListeners = this.optionsChangeListenersMap.get(optionKey);
        if (optionChangeListeners != null) {
            optionChangeListeners.remove(optionChangeListener);
        }
    }

    public void notifyOptionChangeListeners(String key, Object oldValue, Object newValue) {
        List<IPhpProjectOptionChangeListener> optionChangeListeners = this.optionsChangeListenersMap.get(key);
        if (optionChangeListeners == null) {
            return;
        }
        for (IPhpProjectOptionChangeListener phpProjectOptionChangeListener : optionChangeListeners) {
            phpProjectOptionChangeListener.notifyOptionChanged(oldValue, newValue);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public Object getOption(String key) {
        return this.preferences.get(key, null);
    }

    public void setOption(String key, Object value) {
        Object oldValue = this.getOption(key);
        if (oldValue != null ? value != null && value.equals(oldValue) : value == null) {
            return;
        }
        this.preferences.put(key, value.toString());
        this.flushPrefs();
        this.notifyOptionChangeListeners(key, oldValue, value);
    }

    public Object removeOption(String key) {
        Object object = this.getOption(key);
        if (object != null) {
            this.preferences.remove(key);
            this.flushPrefs();
        }
        return object;
    }

    private void flushPrefs() {
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            PHPEplPlugin.logError("Unexpected exception", e);
        }
    }

    public Object removeOptionNotify(String key) {
        Object object = this.removeOption(key);
        this.notifyOptionChangeListeners(key, object, null);
        return object;
    }

    public void modifyIncludePathEntry(IIncludePathEntry newEntry, IProject jproject, IPath containerPath, IProgressMonitor monitor) {
        throw new RuntimeException("implement me");
    }

    public IIncludePathEntry[] readRawIncludePath() {
        return this.includePathEntries;
    }

    public void removeResourceFromIncludePath(IResource resource) {
        if (this.includePathEntries.length == 0) {
            return;
        }
        ArrayList<IIncludePathEntry> newIncludePathEntries = new ArrayList<IIncludePathEntry>(this.includePathEntries.length);
        IIncludePathEntry[] iIncludePathEntryArray = this.includePathEntries;
        int n = this.includePathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IIncludePathEntry entry = iIncludePathEntryArray[n2];
            if (entry.getResource() != resource) {
                newIncludePathEntries.add(entry);
            }
            ++n2;
        }
        try {
            this.setRawIncludePath(newIncludePathEntries.toArray(new IIncludePathEntry[newIncludePathEntries.size()]), null);
            return;
        }
        catch (Exception e) {
            PHPEplPlugin.logError("Unexpected exception", e);
            return;
        }
    }

    public void renameResourceAtIncludePath(IResource from, IResource to) {
        if (this.includePathEntries.length == 0) {
            return;
        }
        ArrayList<IIncludePathEntry> newIncludePathEntries = new ArrayList<IIncludePathEntry>(this.includePathEntries.length);
        IIncludePathEntry[] iIncludePathEntryArray = this.includePathEntries;
        int n = this.includePathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IIncludePathEntry entry = iIncludePathEntryArray[n2];
            if (entry.getResource() == from) {
                IIncludePathEntry newSourceEntry = IncludePathEntry.newProjectEntry(to.getFullPath(), to, false);
                newIncludePathEntries.add(newSourceEntry);
            } else {
                newIncludePathEntries.add(entry);
            }
            ++n2;
        }
        try {
            this.setRawIncludePath(newIncludePathEntries.toArray(new IIncludePathEntry[newIncludePathEntries.size()]), null);
        }
        catch (Exception e) {
            PHPEplPlugin.logError("Unexpected exception", e);
        }
    }

    public void setRawIncludePath(IIncludePathEntry[] newIncludePathEntries, SubProgressMonitor subProgressMonitor) {
        IIncludePathEntry[] oldValue = this.includePathEntries;
        this.includePathEntries = newIncludePathEntries;
        IncludePathEntry.updateProjectReferences(this.includePathEntries, oldValue, this.project, subProgressMonitor);
        this.saveIncludePath();
        this.notifyOptionChangeListeners("com.aptana.editor.php.epl.includePath", oldValue, newIncludePathEntries);
    }

    private void saveIncludePath() {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            XMLWriter xmlWriter = new XMLWriter(s);
            xmlWriter.startTag("includepath", null);
            IIncludePathEntry[] iIncludePathEntryArray = this.includePathEntries;
            int n = this.includePathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IIncludePathEntry entry = iIncludePathEntryArray[n2];
                ((IncludePathEntry)entry).elementEncode(xmlWriter, this.project.getFullPath(), true);
                ++n2;
            }
            xmlWriter.endTag("includepath");
            xmlWriter.flush();
            xmlWriter.close();
            this.preferences.put("com.aptana.editor.php.epl.includePath", new String(s.toByteArray()));
            this.flushPrefs();
            this.validateIncludePath();
        }
        catch (IOException e) {
            PHPEplPlugin.logError("Unexpected exception", e);
        }
    }

    private void loadIncludePath() {
        try {
            Element cpElement;
            String includePathXml = this.preferences.get("com.aptana.editor.php.epl.includePath", null);
            if (includePathXml == null) {
                return;
            }
            StringReader reader = new StringReader(includePathXml);
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
                }
                catch (Exception exception) {
                    throw new IOException(CoreMessages.getString("PHPProjectOptions_1"));
                }
            }
            finally {
                ((Reader)reader).close();
            }
            ArrayList<IIncludePathEntry> paths = new ArrayList<IIncludePathEntry>();
            NodeList list = cpElement.getElementsByTagName("includepathentry");
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node.getNodeType() == 1) {
                    IIncludePathEntry entry = IncludePathEntry.elementDecode((Element)node, this);
                    paths.add(entry);
                }
                ++i;
            }
            int pathSize = paths.size();
            this.includePathEntries = new IIncludePathEntry[pathSize];
            paths.toArray(this.includePathEntries);
        }
        catch (IOException e) {
            PHPEplPlugin.logError("Unexpected exception", e);
        }
    }

    private void loadOldConfiguration() {
        IFile optionsFile = this.project.getFile(OLD_FILE_NAME);
        if (!optionsFile.exists()) {
            return;
        }
        ArrayList<IIncludePathEntry> paths = new ArrayList<IIncludePathEntry>();
        this.includePathEntries = EMPTY_INCLUDEPATH;
        try {
            Element cpElement;
            InputStreamReader reader = new InputStreamReader(optionsFile.getContents());
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
                }
                catch (Exception exception) {
                    throw new IOException(CoreMessages.getString("PHPProjectOptions_1"));
                }
            }
            finally {
                ((Reader)reader).close();
            }
            if (!cpElement.getNodeName().equalsIgnoreCase(TAG_OPTIONS)) {
                throw new IOException(CoreMessages.getString("PHPProjectOptions_1"));
            }
            NodeList list = cpElement.getElementsByTagName(TAG_OPTION);
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                Element element = (Element)list.item(i);
                String key = element.getAttribute("name");
                Node firstChild = element.getFirstChild();
                if (firstChild != null) {
                    String value = firstChild.getNodeValue().trim();
                    this.preferences.put(key, value);
                }
                ++i;
            }
            list = cpElement.getElementsByTagName("includepath");
            if (list.getLength() > 0) {
                Element includePathElement = (Element)list.item(0);
                list = includePathElement.getElementsByTagName("includepathentry");
                length = list.getLength();
                int i2 = 0;
                while (i2 < length) {
                    Node node = list.item(i2);
                    if (node.getNodeType() == 1) {
                        IIncludePathEntry entry = IncludePathEntry.elementDecode((Element)node, this);
                        paths.add(entry);
                    }
                    ++i2;
                }
                int pathSize = paths.size();
                this.includePathEntries = new IIncludePathEntry[pathSize];
                paths.toArray(this.includePathEntries);
            }
            this.saveIncludePath();
            optionsFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            PHPEplPlugin.logError("Unexpected exception", e);
        }
        catch (CoreException e) {
            PHPEplPlugin.logError("Unexpected exception", e);
        }
    }

    public void validateIncludePath() {
        this.clearMarkers();
        IIncludePathEntry[] iIncludePathEntryArray = this.includePathEntries;
        int n = this.includePathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IIncludePathEntry element = iIncludePathEntryArray[n2];
            String message = element.validate();
            if (message != null) {
                this.addError(message);
            }
            ++n2;
        }
    }

    private void addError(String message) {
        try {
            IMarker marker = this.project.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("location", (Object)LOCATION_INCLUDE_PATH);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("priority", 2);
            marker.setAttribute("severity", 1);
            marker.setAttribute(OWNER_ATTRIBUTE, (Object)OWNER_PHP_INCLUDE_PATH);
        }
        catch (CoreException coreException) {}
    }

    private void clearMarkers() {
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = this.project.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker element = iMarkerArray[n2];
                if (OWNER_PHP_INCLUDE_PATH.equals(element.getAttribute(OWNER_ATTRIBUTE))) {
                    element.delete();
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
    }
}

